﻿Partial Public Class MainPage
    Inherits PhoneApplicationPage

    Public Sub New()
        InitializeComponent()
        AddHandler Touch.FrameReported, AddressOf OnTouchFrameReported
    End Sub


    Private Sub OnTouchFrameReported(ByVal sender As Object, ByVal args As TouchFrameEventArgs)
        Dim touchPoint = args.GetPrimaryTouchPoint(Me)

        If touchPoint IsNot Nothing AndAlso
            touchPoint.Action = TouchAction.Down Then
            args.SuspendMousePromotionUntilTouchUp()
        End If

        If touchPoint IsNot Nothing AndAlso
            TypeOf touchPoint.TouchDevice.DirectlyOver Is Rectangle Then
            Dim rectangle = (TryCast(touchPoint.TouchDevice.DirectlyOver, Rectangle))

            ' This DataContext is an object of type Student
            Dim dataContext = rectangle.DataContext
            studentDisplay.DataContext = dataContext

            If touchPoint.Action = TouchAction.Down Then
                studentDisplay.Visibility = System.Windows.Visibility.Visible

            ElseIf touchPoint.Action = TouchAction.Up Then
                studentDisplay.Visibility = System.Windows.Visibility.Collapsed
            End If
        End If
    End Sub
End Class
